﻿function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
		    [Parameter(Mandatory=$false)]
		    $Component,
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }


$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"
$SMSTS_WinSystemLocale = $tsenv.Value('SMSTS_WinSystemLocale')

$Mode = $tsenv.Value('SMSTS_TSWaaSMode') #This Var is set at the start of each TS
if ($Mode -ne $null)
    {
    if ($Mode -eq "Upgrade")
    {
    $CurrentOSInfo = Get-Item -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
    $ReleaseID_CurrentOS = $CurrentOSInfo.GetValue('ReleaseId')
    if ($ReleaseID_CurrentOS -eq $tsenv.Value('SMSTS_Build'))
        {
        $ComponetSuffix = "PostSetup"
        }
    Else
        {
        $ComponetSuffix = "PreSetup"
        }    
    $Component = "$($mode):LP:$($ComponetSuffix)"
    }
    Else
        {$Component = "$($mode):LP"}
    }
else {$Component = "LangCaps"}

Write-Output "-------------------------------------------"
Write-Output "Starting Language Capabilities Script"
CMTraceLog -Message  "Starting Language Capabilities Script" -Type 1 -LogFile $LogFile -Component $Component

#Create Temp Folder to copy all language files to for the Setup Engine to Consume
$WaaSLangPacksFolder = "$env:ProgramData\WaaS\WaaSLangPacks"
if (Test-Path -Path $WaaSLangPacksFolder){Remove-Item -Path $WaaSLangPacksFolder -Recurse -Force}
$NULL = New-Item -Path $WaaSLangPacksFolder -ItemType Directory -Force

$LangPackIDs = (New-Object -COMObject Microsoft.SMS.TSEnvironment).GetVariables() | Where-Object {$_ -Like "LANGPACKID_*"}

foreach ($LangPackID in $LangPackIDs){

    #Setting the Language Pack Path Variable LANGPACKID_FR-CA
    $TSCACHE = "_SMSTSPackageCacheLocation" + $tsenv.Value($LangPackID)
    $CCMCACHE = "_SMSTS" + $tsenv.Value($LangPackID)
    if ($tsenv.Value($TSCACHE)) {$WorkingPath = $tsenv.Value($TSCACHE)}
    if ($tsenv.Value($CCMCACHE)) {$WorkingPath = $tsenv.Value($CCMCACHE)}
    write-output "$LangPackID Files located $WorkingPath"
    Write-Output "Copying $WorkingPath to $WaaSLangPacksFolder"
    Copy-Item -Path "$WorkingPath\*" -Destination $WaaSLangPacksFolder -Recurse -Force -Verbose
    CMTraceLog -Message  " Working on $LangPackID - $($tsenv.Value($LangPackID))" -Type 1 -LogFile $LogFile -Component $Component
    CMTraceLog -Message  "  Copying $WorkingPath to $WaaSLangPacksFolder" -Type 1 -LogFile $LogFile -Component $Component
}

#Remove Language Packs that aren't used, keeping the capabilities. 

#Get List of Language Pack Files to delete that do not machine the one we'd actually want to install.
<# - Lets just keep it all for now.
if ($SMSTS_WinSystemLocale)
    {
    #This will skip including the Language Pack File that matches the current WinSystemLocale, so it does NOT get marked for deletion.
    $LanguagePackFiles = Get-ChildItem -Path "$WaaSLangPacksFolder\Offline\*" -include Microsoft-Windows-Client-Language-Pack* | Where-Object {$_.Name -notmatch $SMSTS_WinSystemLocale}
    }
else
    {
    $LanguagePackFiles = Get-ChildItem -Path "$WaaSLangPacksFolder\Offline\*" -include Microsoft-Windows-Client-Language-Pack*
    }


Write-Output "Cleaning up unneeded Language Pack Files"
CMTraceLog -Message  "  Cleaning up unneeded Language Pack Files" -Type 1 -LogFile $LogFile -Component $Component
ForEach ($LanguagePackFile in $LanguagePackFiles)
    {
    Remove-Item -Path $LanguagePackFile.FullName -Force -Verbose
    CMTraceLog -Message  "   Removing $($LanguagePackFile.FullName)" -Type 1 -LogFile $LogFile -Component $Component
    }
#>

$tsenv.Value('LANG01') = $WaaSLangPacksFolder
write-output "LANG01:$($tsenv.Value('LANG01'))"
CMTraceLog -Message  "  LANG01:$($tsenv.Value('LANG01'))" -Type 1 -LogFile $LogFile -Component $Component
